#include "BaseUsbUartBridge.h"
DigitalOut led_xbee(LED1),led_usb(LED2),led_reset(LED3),led_heartbeat(LED4);
RawSerial pc(MBED_UARTUSB);
#if defined(TARGET_LPC4088)
#define XBEE_UART P4_22,P4_23
DigitalOut xbee_rts(P4_21);
DigitalOut xbee_dtr(P4_19);
DigitalOut xbee_reset(P4_17);
DigitalIn reset_sw(P2_10);
#define SW_MODE PullUp
#elif defined(TARGET_LPC1768)
#define XBEE_UART p9,p10
DigitalOut xbee_rts(p21);
DigitalOut xbee_dtr(p22);
DigitalOut xbee_reset(p30);
DigitalIn reset_sw(p14);
#define SW_MODE PullDown
#else
#error "target error"
#endif

class USB_XBee : public BaseUsbUartBridge {
public:
    USB_XBee(PinName tx, PinName rx) : BaseUsbUartBridge(tx, rx) {}
    virtual void controlLineStateChanged(int rts, int dtr){
        xbee_rts = rts ^ 1;
        xbee_dtr = dtr ^ 1;
    }
    virtual void monitor(src_t src, uint8_t c) {
        switch(src) {
            case _UART: led_xbee = !led_xbee; break;
            case _USB: led_usb = !led_usb; break;
        }
        //pc.putc(c);// debug
    }
};

USB_XBee usb_xbee(XBEE_UART);

int main() {
    pc.baud(115200);

    xbee_rts = 0;
    xbee_dtr = 0;
    xbee_reset = 1;
    reset_sw.mode(SW_MODE);
    int prev_sw = 1;

    Timer heartbeat_t;
    heartbeat_t.reset();
    heartbeat_t.start();
    while(1) {
        if (reset_sw ^ prev_sw) {
            prev_sw = reset_sw;
            xbee_reset = prev_sw ^ (SW_MODE == PullDown ? 1 : 0);
            led_reset = xbee_reset;
        }
        if (heartbeat_t.read_ms() > 500) {
            heartbeat_t.reset();
            led_heartbeat = !led_heartbeat;
        }
        usb_xbee.poll();
    }
}
