#include "mbed.h"
#include "uvc.h"
#include "EthernetNetIf.h"
//#include "WIZ820ioNetIf.h"
#include "HTTPServer.h"
#include "WebcamServerConfig.h"
#include "WebcamHandler.h"
#include "WebcamInput.h"
Serial pc(USBTX, USBRX);

HTTPServer svr;

EthernetNetIf eth;
//WIZ820ioNetIf eth;


uvc* Webcam[CAM_COUNT];

int main() {
    pc.baud(921600);
    printf("%s\n", __FILE__);

    for(int i = 0; i < CAM_COUNT; i++) {
        uvc* cam = new uvc(i);
        cam->SetImageSize(160, 120);
        WebcamInput* input = new WebcamInput(i);
        cam->attach(input);
        if (cam->setup() < 0) exit(1);
        Webcam[i] = cam;
    }

    int ethErr = eth.setup();
    if (ethErr < 0) exit(1);
    IpAddr ip = eth.getIp();
    printf("http://%d.%d.%d.%d/\n", ip[0], ip[1], ip[2], ip[3]);
    svr.addHandler<WebcamHandler>("/");
    svr.bind(80);

    while(1) {
        Net::poll();
        for(int i = 0; i < CAM_COUNT; i++) {
            Webcam[i]->poll();
        }
    }
}
