#ifndef WEBCAM_INPUT_H
#define WEBCAM_INPUT_H
#include "usb_mjpeg.h"

#define INTERVAL_MS 1000
#define IMAGE_SIZE  4096

class WebcamInput : public usb_stream {
public:
    WebcamInput(int cam = 0);
    virtual void input(uint16_t frame, uint8_t* buf, int len);
    int m_seq;
    uint8_t m_bfh;
    int m_pos;
    int m_size;
    uint8_t* m_image_buf;
    Timer m_t;
    int m_cam;
};

#endif //WEBCAM_INPUT_H