
/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "WebcamServerConfig.h"
#include "WebcamHandler.h"

//#define __DEBUG
#include "mydbg.h"
//#include "dbg/dbg.h"

#define _D(...) #__VA_ARGS__

#if CAM_COUNT == 1
const char* html_index = _D(
<html>
<head>
<meta http-equiv="refresh" content="10">
</head>
<body>
<a href="/cam.jpg"><img src="/cam.jpg" width="320" height="240"></a>
</body>
</html>
);
#endif

#if CAM_COUNT == 2
const char* html_index = _D(
<html>
<head>
<meta http-equiv="refresh" content="10">
</head>
<body>
<img src="/cam0.jpg">
<img src="/cam1.jpg">
</body>
</html>
);
#endif

#define CHUNK_SIZE 128

WebcamHandler::WebcamHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) 
    : HTTPRequestHandler(rootPath, path, pTCPSocket)
{}

void WebcamHandler::doGet()
{
  DBG("\r\nIn WebcamHandler::doGet() - rootPath=%s, path=%s\r\n", rootPath().c_str(), path().c_str());
  if (path().find("/cam") == 0) {
      int cam = 0;
      if (path().find("/cam0") == 0) {
          cam = 1;
      }
      DBG_ASSERT(cam >= 0);
      DBG_ASSERT(cam <= 1);
      m_buf = (char*)m_image[cam].buf;
      m_buf_len = m_image[cam].len;
      respHeaders()["Content-Type"] = "image/jpeg";
      m_busy = true;
  } else if (path().length() == 0) {
      m_buf = const_cast<char*>(html_index);
      m_buf_len = strlen(html_index);
      respHeaders()["Content-Type"] = "text/html";
  } else {
      m_buf = NULL;
  }
  if(m_buf == NULL)
  {
    setErrCode(404);
    const char* msg = "iamge not found.";
    setContentLen(strlen(msg));
    respHeaders()["Content-Type"] = "text/html";
    respHeaders()["Connection"] = "close";
    writeData(msg,strlen(msg)); //Only send header
    DBG("\r\nExit WebcamHandler::doGet() w Error 404\r\n");
    return;
  }
  m_pos = 0;
  DBG("m_buf_len=%d\n",  m_buf_len);
  setContentLen(m_buf_len);
  respHeaders()["Connection"] = "close";
  onWriteable();
}

void WebcamHandler::onWriteable() //Data has been written & buf is free
{
  DBG("\r\nImageHandler::onWriteable() event\r\n");
  if(m_buf == NULL)
  {
    //Error has been served, now exit
    close();
    return;
  }
  
  while(true) {
    int len;
    if ((m_buf_len - m_pos) > CHUNK_SIZE) {
        len = CHUNK_SIZE;
    } else {
        len = m_buf_len - m_pos;
    }
    if(len > 0) {
      int writtenLen = writeData(m_buf + m_pos, len);
      DBG("writtenLen=%d m_buf=%p m_pos=%d len=%d\n", writtenLen, m_buf, m_pos, len);
      if(writtenLen < 0) //Socket error
      {
        DBG("WebcamHandler: Socket error %d\n", writtenLen);
        if(writtenLen == TCPSOCKET_MEM) {
          return; //Wait for the queued TCP segments to be transmitted
        } else {
          //This is a critical error
          close();
          return; 
        }
      } 
      else if(writtenLen < len) //Short write, socket's buffer is full
      {
        m_pos += writtenLen;
        return;
      }
      m_pos += writtenLen;
    } else {
      close(); //Data written, we can close the connection
      return;
    }
  }
}

void WebcamHandler::onClose()
{
    DBG("m_busy=%d\n", m_busy);
    m_busy = false;
}

//static init
struct stimage WebcamHandler::m_image[] = {{NULL,0},{NULL,0}};
bool WebcamHandler::m_busy = false;
 
void WebcamHandler::setImage(uint8_t* buf, int len, int cam)
{
    DBG_ASSERT(cam >= 0);
    DBG_ASSERT(cam <= 1);
    m_image[cam].buf = buf;
    m_image[cam].len = len;
}
