#include "WebcamServerConfig.h"
#include "WebcamInput.h"
#include "WebcamHandler.h"
#include "myjpeg.h"
//#define __DEBUG
#include "mydbg.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);


WebcamInput::WebcamInput(int cam)
    :m_seq(0),m_cam(cam)
{
    DBG("%p cam=%d\n", this, cam);
    m_t.reset();
    m_t.start();
    m_size = IMAGE_SIZE;
    m_image_buf = new uint8_t[m_size];
    DBG_ASSERT(m_image_buf);
}

void WebcamInput::input(uint16_t frame, uint8_t* buf, int len)
{
    if (len <= 12) {
        return;
    }
    uint8_t* data = buf+12;
    int data_len = len - 12;

    switch(m_seq) {
        case 0:
            if (m_t.read_ms() > INTERVAL_MS) {
                m_seq++;
            }
            break;
        case 1:
            if (!WebcamHandler::busy()) {
                m_seq++;
            }
            break;
        case 2:
            if ((buf[1]^m_bfh)&0x01) { // FID change
                m_pos = 0;
                if (m_cam == 0) {
                    led3 = 1;
                } else {
                    led4 = 1;
                }
                m_seq++;
            } else {
                break;
            }
        case 3:
            for(int i = 0; m_pos < IMAGE_SIZE && i < data_len; i++) {
                m_image_buf[m_pos++] = data[i];
            }
            if (buf[1]&0x02) { // EOF
#ifdef UVC_INSERT_DHT
                myjpeg JPEG(m_image_buf, m_pos, m_size);
                JPEG.analytics();
                if (JPEG.DHT_pos == 0) {
                    m_pos = JPEG.insertDHT();
                }
#endif // UVC_INSERT_DHT
                WebcamHandler::setImage(m_image_buf, m_pos, m_cam);
                m_t.reset();
                m_seq = 0;
                if (m_cam == 0) {
                   led3 = 0;
                } else {
                   led4 = 0;
                }
            }
            break;
    }        
    m_bfh = buf[1];
    if (m_cam == 0) {
        led1 = buf[1]&1; // FID
    } else {
        led2 = buf[1]&1; // FID
    }
    //led4 = WebcamHandler::busy();
}
