// w5200debug.cpp 2013/3/24
#include "mbed.h"
#include <ctype.h>

void print_bytes(FILE* stream, char* s, uint8_t* buf, int len)
{
    fprintf(stream, "%s %d:", s, len);
    for(int i = 0; i < len; i++) {
        fprintf(stream, " %02X", buf[i]);
    }
    fprintf(stream, "\n");
}

void print_str(FILE* stream, uint8_t* buf, int len)
{
    fprintf(stream, "%p %d:", buf, len);
    for(int i = 0; i < len; i++) {
        fprintf(stream, " %02X", buf[i]);
    }
    fprintf(stream, " : ");
    for(int i = 0; i < len; i++) {
        char c = buf[i];
        if (!isprint(c)) {
            c = '.';
        }
        fprintf(stream, "%c", c);
    }
    fprintf(stream, "\n");
}

void print_hex(FILE* stream, uint8_t* p, int len)
{
    for(int i = 0; i < len; i++) {
        if (i%16 == 0) {
            fprintf(stream, "%p:", p);
        }
        fprintf(stream, " %02X", *p);
        p++;
        if (i%16 == 15) {
            fprintf(stream, "\n");
        }
    }
    fprintf(stream, "\n");
}
