// WIZ820ioNetIf.cpp 2013/3/24
#include "WIZ820ioNetIf.h"
#include "DHCPClient.h"
#include "w5200.h"
extern SPI* pSPI; // w5200.cpp
extern DigitalOut* pCS; // w5200.cpp

DigitalOut* pRESET = NULL;

WIZ820ioNetIf::WIZ820ioNetIf(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset)
                                :MyNetIf(), m_netmask(255,255,255,255), m_gateway(), m_hostname(NULL)
{
    m_hostname = NULL;
    m_useDhcp = true;
    pin_assign(mosi, miso, sclk, cs, reset);
}

void WIZ820ioNetIf::config(IpAddr ip, IpAddr netmask, IpAddr gateway, IpAddr dns)
{
    m_ip = ip;
    m_netmask = netmask;
    m_gateway = gateway;
    m_dns = dns;
    m_useDhcp = false;
}

void WIZ820ioNetIf::pin_assign(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset)
{
    pSPI = new SPI(mosi, miso, sclk);
    pCS = new DigitalOut(cs);
    if (reset != NC) {
        pRESET = new DigitalOut(reset);
    }
}

void hardware_reset() {
    if (pRESET) {
        pRESET->write(1);
        pRESET->write(0);
        wait_us(2);
        pRESET->write(1);
        wait_ms(150);
    }
}

bool wait_linkup(int timeout_ms = 5*1000) {
    Timer link_t;
    link_t.reset();
    link_t.start();
    uint8_t status = 0x00;
    while(link_t.read_ms() < timeout_ms) {
        status = W5200.readPHYSTATUS();
        if (status & 0x20) {
            printf("Link Up\n");
            return true;
        }
        wait_ms(50);
    }  
    printf("Link down\n");
    if (status & 0x08) {
        printf("Power down mode\n");
    }
    return false;
}

int WIZ820ioNetIf::setup(int timeout_ms) {
    hardware_reset();
    W5200.init();
    if (!wait_linkup()) {
        return W5200_SETUP_ERR_LINK_DOWN;
    }

    MyNetIf::init();
    uint8_t mac[6];
    mbed_mac_address((char*)mac);
    W5200.setMACAddress(mac);
    printf("HW Addr is : %02x:%02x:%02x:%02x:%02x:%02x.\n", mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]);
    if(! m_useDhcp) {
        return W5200_OK;
    }
    return IPrenew(timeout_ms);
}

W5200Err WIZ820ioNetIf::IPrenew(int timeout_ms) {
    printf("DHCP Started, waiting for IP...\n");  
    DHCPClient dhcp;
    int err = dhcp.setup(timeout_ms);
    if (err == (-1)) {
        printf("Timeout.\n");
        return W5200_TIMEOUT;
    }
    printf("Connected, IP: %d.%d.%d.%d\n", dhcp.yiaddr[0], dhcp.yiaddr[1], dhcp.yiaddr[2], dhcp.yiaddr[3]);
    m_ip = IpAddr(dhcp.yiaddr[0], dhcp.yiaddr[1], dhcp.yiaddr[2], dhcp.yiaddr[3]);
    m_netmask = IpAddr(dhcp.netmask[0],dhcp.netmask[1],dhcp.netmask[2],dhcp.netmask[3]);
    m_gateway = IpAddr(dhcp.gateway[0],dhcp.gateway[1],dhcp.gateway[2],dhcp.gateway[3]);
    uint8_t t[4];
    t[0] = m_ip[0];
    t[1] = m_ip[1];
    t[2] = m_ip[2];
    t[3] = m_ip[3];
    W5200.writeSIPR(t);
    t[0] = m_netmask[0];
    t[1] = m_netmask[1];
    t[2] = m_netmask[2];
    t[3] = m_netmask[3];
    W5200.writeSUBR(t);
    t[0] = m_gateway[0];
    t[1] = m_gateway[1];
    t[2] = m_gateway[2];
    t[3] = m_gateway[3];
    W5200.writeGAR(t);
    m_dns = IpAddr(dhcp.dnsaddr[0],dhcp.dnsaddr[1],dhcp.dnsaddr[2],dhcp.dnsaddr[3]);
    return W5200_OK;
}

W5200Err WIZ820ioNetIf::IPrelease(int timeout_ms) {
    return W5200_OK;
}
