// WIZ820ioNetIf.h 2013/3/24

/** \file
WIZ820io network interface header file
*/
#pragma once
#include "MyNetIf.h"

///W5200 network interface return codes
enum W5200Err
{
  __W5200_MIN = -0xFFFF,
  W5200_TIMEOUT, ///<Timeout during setup
  W5200_SETUP_ERR,
  W5200_SETUP_ERR_LINK_DOWN,
  W5200_OK = 0 ///<Success
};

///WIZ820io network interface
class WIZ820ioNetIf : public MyNetIf {
public:
    /** Create a WIZ820io ethernet interface
     *
     * @param mosi SPI mosi pin connected to WIZ820io
     * @param miso SPI miso pin conencted to WIZ820io
     * @param sclk SPI sclk pin connected to WIZ820io
     * @param cs   DigitalOut pin used as WIZ820io select
     * @param reset DigitalOut pin WIZ820io hardware reset 
     */
    WIZ820ioNetIf(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset);
    void config(IpAddr ip, IpAddr netmask, IpAddr gateway, IpAddr dns); //W/o DHCP
    ///Brings the interface up
    /**
    Uses DHCP if necessary
    @param timeout_ms : You can set the timeout parameter in milliseconds, if not it defaults to 15s
    @return : 0 on success or -1 on timeout
    */    
    int setup(int timeout_ms = 15000);
    W5200Err IPrenew(int timeout_ms = 15000);
    W5200Err IPrelease(int timeout_ms = 15000);
    IpAddr m_dns;
private:
    void pin_assign(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset);
    bool m_useDhcp;
    IpAddr m_netmask;
    IpAddr m_gateway;
    const char* m_hostname;
};
