// MyNetUdpSocket.cpp 2012/4/16
#include "mbed.h"
#include "MyNetUdpSocket.h"
#include "w5200.h"

//#define DEBUG

#ifdef DEBUG
#include "Utils.h"
#define PRINT_FUNC() printf("%p %d:%s\n", this,__LINE__,__PRETTY_FUNCTION__)
#else //DEBUG
#define PRINT_FUNC()
#endif //DEBUG

extern int w5200_new_socket(); // MyNetTcpSocket.cpp

MyNetUdpSocket::MyNetUdpSocket(int socket) : NetUdpSocket(),_socket(socket)  {
    PRINT_FUNC();
    if (_socket == (-1)) {
        _socket = w5200_new_socket();
    }
    if (_socket != (-1)) {
        W5200.writeSnMR(_socket, SnMR::UDP); // set UDP mode
    }
}

MyNetUdpSocket::~MyNetUdpSocket() {
    PRINT_FUNC();
    close();
    if (_socket != (-1)) {
        W5200.writeSnMR(_socket, SnMR::CLOSE);
    }
}

NetUdpSocketErr MyNetUdpSocket::bind(const Host& me) {
    PRINT_FUNC();
    if (_socket == (-1)) {
        return NETUDPSOCKET_MEM;
    }
    int port = me.getPort();
    W5200.writeSnPORT(_socket, port);
    W5200.execCmdSn( _socket, Sock_OPEN); // set OPEN command
    return NETUDPSOCKET_OK;
}

int /*if < 0 : NetUdpSocketErr*/ MyNetUdpSocket::sendto(const char* buf, int len, Host* pHost) {
    PRINT_FUNC();
    if (_socket == (-1)) {
        return NETUDPSOCKET_MEM;
    }
    uint8_t ip[4];
    ip[0] = pHost->getIp()[0];
    ip[1] = pHost->getIp()[1];
    ip[2] = pHost->getIp()[2];
    ip[3] = pHost->getIp()[3];
    int port = pHost->getPort();
    W5200.writeSnDIPR(_socket, ip);
    W5200.writeSnDPORT(_socket, port);
    W5200.send_data_processing(_socket, (uint8_t*)buf, len);
    W5200.execCmdSn(_socket, Sock_SEND);
#ifdef DEBUG
    printHex((u8*)buf, len);
    W5200.getIPAddress(ip);
    printf("SIPR: %d.%d.%d.%d Sn_PORT:%d\n", ip[0], ip[1], ip[2], ip[3], W5200.readSnPORT(_socket));
    W5200.readSnDIPR(_socket, ip);
    printf("Sn_DIPR: %d.%d.%d.%d Sn_DPORT:%d\n", ip[0], ip[1], ip[2], ip[3], W5200.readSnDPORT(_socket));
#endif //DEBUG
    return len;
}

int /*if < 0 : NetUdpSocketErr*/ MyNetUdpSocket::recvfrom(char* buf, int len, Host* pHost) {
    PRINT_FUNC();
    if (_socket == (-1)) {
        return NETUDPSOCKET_MEM;
    }
    int size = W5200.getRXReceivedSize(_socket);
    if (size < 8) {
        return -1;
    }
    uint8_t info[8];
    W5200.recv_data_processing(_socket, info, 8);
    W5200.execCmdSn(_socket, Sock_RECV);
    pHost->setIp(IpAddr(info[0],info[1],info[2],info[3]));
    pHost->setPort(info[4]<<8|info[5]);
    size -= 8;
    if (size > len) {
        size = len;
    }    
    W5200.recv_data_processing(_socket, (uint8_t*)buf, size);
    W5200.execCmdSn(_socket, Sock_RECV);
#ifdef DEBUG
    printfBytes("UDP PACKET-INFO", (u8*)info, 8);
    printHex((u8*)buf, size);
#endif //DEBUG
    return size;
}

NetUdpSocketErr MyNetUdpSocket::close() {
    PRINT_FUNC();
    if(m_closed) {
        return NETUDPSOCKET_OK;
    }
    if (_socket == (-1)) {
        return NETUDPSOCKET_MEM;
    }
    m_closed = true;
    cleanUp();
    W5200.writeSnMR(_socket, SnMR::CLOSE);
    return NETUDPSOCKET_OK;
}

NetUdpSocketErr MyNetUdpSocket::poll() {
    PRINT_FUNC();
    NetUdpSocket::flushEvents();
#ifdef DEBUG
    printf("%p socket:%d\n", this,_socket); 
    if (_socket != (-1)) {
        printf("SnMR:%02x SnIR:%02x SnSR:%02x\n",  
            W5200.readSnMR(_socket), W5200.readSnIR(_socket), W5200.readSnSR(_socket));
        uint8_t ip[4];
        W5200.readSnDIPR(_socket, ip);
        printf("Sn_DIPR: %d.%d.%d.%d Sn_DPORT: %d\n", ip[0], ip[1], ip[2], ip[3], W5200.readSnDPORT(_socket));
        uint8_t mac[6];
        W5200.readSnDHAR(_socket, mac);
        printf("Sn_DHAR: %02x:%02x:%02x:%02x:%02x:%02x\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
        printf("Sn_RX_RSR:%5d, Sn_RX_RD:%5d, Sn_RX_WR:%5d\n",
                W5200.readSnRX_RSR(_socket), W5200.readSnRX_RD(_socket), W5200.readSnRX_WR(_socket));
        printf("Sn_TX_FSR:%5d, Sn_TX_RD:%5d, Sn_TX_WR:%5d\n",
                W5200.readSnTX_FSR(_socket), W5200.readSnTX_RD(_socket), W5200.readSnTX_WR(_socket));
    }
    wait_ms(200);    
#endif //DEBUG
    if (_socket != (-1)) {
        if (W5200.getRXReceivedSize(_socket) > 0) {
            queueEvent(NETUDPSOCKET_READABLE);
        }
    }
    return NETUDPSOCKET_OK;
}

void MyNetUdpSocket::cleanUp() //Flush input buffer
{
    PRINT_FUNC();
    if (_socket == (-1)) {
        return;
    }
    while(W5200.getRXReceivedSize(_socket) > 0) {
        uint8_t temp[1];
        W5200.recv_data_processing(_socket, temp, 1);
        W5200.execCmdSn(_socket, Sock_RECV);
    }    
}
