// MyNetDnsRequest.h 2012/4/19
#ifndef MYNETDNSREQUEST_H
#define MYNETDNSREQUEST_H
#include "if/net/netdnsrequest.h"
#include "UDPSocket.h"
 
class MyNetDnsRequest : public NetDnsRequest {
public:
    MyNetDnsRequest(const char* hostname);
    MyNetDnsRequest(Host* pHost);
    virtual ~MyNetDnsRequest();
    virtual void poll();
    virtual void close();
protected:
    void callback(UDPSocketEvent e);
    int response(uint8_t buf[], int size);
    int query(uint8_t buf[], int size, const char* hostname);
    void resolve(const char* hostname);
    uint8_t m_id[2];
    Timer m_interval;
    int m_retry;
private:
    enum MyNetDnsState
    {
        MYNETDNS_START,
        MYNETDNS_PROCESSING, //Req has not completed
        MYNETDNS_NOTFOUND,
        MYNETDNS_ERROR,
        MYNETDNS_OK
    };
    MyNetDnsState m_state;
    bool m_cbFired;
    bool m_closing;
    UDPSocket *m_udp;
};
#endif //MYNETDNSREQUEST_H
