// w5200debug.h 2013/3/24
#pragma once

#ifdef DEBUG
#define DBG(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#define DBG_BYTES(A,B,C) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);print_bytes(stderr,A,B,C);}while(0);
#define DBG_STR(A,B) do{fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_str(stderr,A,B);}while(0);
#define DBG_HEX(A,B) do{fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_hex(stderr,A,B);}while(0);
#else
#define DBG_BYTES(A,B,C) while(0);
#define DBG_STR(A,B) while(0);
#define DBG_HEX(A,B) while(0);
#define DBG(...) while(0);
#endif

#define DEBUG2 
#ifdef DEBUG2
#define DBG2(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#else
#define DBG2(...) while(0);
#endif

void print_bytes(FILE* stream, char* s, uint8_t* buf, int len);
void print_str(FILE* stream, uint8_t* p, int len);
void print_hex(FILE* stream, uint8_t* p, int len);
