// MyNetTcpSocket.h 2012/4/16
#ifndef MYNETTCPSOCKET_H
#define MYNETTCPSOCKET_H
#include "if/net/nettcpsocket.h"

class MyNetTcpSocket : public NetTcpSocket {
public:
    MyNetTcpSocket(int socket = (-1));
    virtual ~MyNetTcpSocket();
    virtual NetTcpSocketErr bind(const Host& me);
    virtual NetTcpSocketErr listen();
    virtual NetTcpSocketErr connect(const Host& host);
    virtual NetTcpSocketErr accept(Host* pClient, NetTcpSocket** ppNewNetTcpSocket);
    virtual int /*if < 0 : NetTcpSocketErr*/ send(const char* buf, int len);
    virtual int /*if < 0 : NetTcpSocketErr*/ recv(char* buf, int len);
    virtual NetTcpSocketErr close();
    virtual NetTcpSocketErr poll();
protected:
    int _socket;
    bool wait_accept;
private:
    void cleanUp(); //Flush input buffer
    queue<MyNetTcpSocket*> m_lpInNetTcpSocket;
};
#endif //MYNETTCPSOCKET_H