// MyNetIf.cpp 2012/4/17
#include "mbed.h"
#include "MyNetIf.h"
#include "MyNetTcpSocket.h"
#include "MyNetUdpSocket.h"
#include "MyNetDnsRequest.h"

//#define DEBUG

#ifdef DEBUG
#include "w5100.h"
#include "Utils.h"
#define PRINT_FUNC() printf("%p %d:%s\n", this,__LINE__,__PRETTY_FUNCTION__)
#else //DEBUG
#define PRINT_FUNC()
#endif //DEBUG

MyNetIf::MyNetIf() : NetIf(), m_init(false)
{
    PRINT_FUNC();
}

MyNetIf::~MyNetIf() {
    PRINT_FUNC();
}

void MyNetIf::init() {
    PRINT_FUNC();
}

NetTcpSocket* MyNetIf::tcpSocket() {
    PRINT_FUNC();
    return new MyNetTcpSocket();
}

NetUdpSocket* MyNetIf::udpSocket() {
    PRINT_FUNC();
    return new MyNetUdpSocket();
}

NetDnsRequest* MyNetIf::dnsRequest(const char* hostname) {
    PRINT_FUNC();
    return new MyNetDnsRequest(hostname);
}

NetDnsRequest* MyNetIf::dnsRequest(Host* pHost) {
    PRINT_FUNC();
    return new MyNetDnsRequest(pHost);
}

void MyNetIf::poll() {
    PRINT_FUNC();
#ifdef DEBUG
    printf("SnMR:");
    for(int s = 0; s < MAX_SOCK_NUM; s++) {
        printf(" %02x", W5100.readSnMR(s));
    }
    printf("\n");

    printf("SnIR:");
    for(int s = 0; s < MAX_SOCK_NUM; s++) {
        printf(" %02x", W5100.readSnIR(s));
    }
    printf("\n");

    printf("SnSR:");
    for(int s = 0; s < MAX_SOCK_NUM; s++) {
        printf(" %02x", W5100.readSnSR(s));
    }
    printf("\n");

    printf("SnPORT:");
    for(int s = 0; s < MAX_SOCK_NUM; s++) {
        printf(" %d", W5100.readSnPORT(s));
    }
    printf("\n");
    
    wait_ms(500);
#endif //DEBUG
}
