// UvcCam.h 2013/2/11
#ifndef UVC_CAM_H
#define UVC_CAM_H

#define UVC_160x120 2
#define UVC_176x144 3
#define UVC_320x176 4
#define UVC_320x240 5
#define UVC_352x288 6
#define UVC_432x240 7
#define UVC_640x480 1
#define UVC_544x288 8
#define UVC_640x360 9
#define UVC_752x416 10
#define UVC_800x448 11
#define UVC_800x600 12

#define UVC_MJPEG 2
#define UVC_YUY2  1

#define VERBOSE(...) do{printf(__VA_ARGS__);} while(0);

class UvcCam : public BaseUvc {
public:
    UvcCam(int formatIndex = UVC_MJPEG, int frameIndex = UVC_160x120, uint32_t interval = _5FPS, ControlEp* ctlEp = NULL);
    static bool check(ControlEp* ctlEp);
    uint16_t vid;
    uint16_t pid;
};

class UvcCfg {
public:
    UvcCfg(int formatIndex, int frameIndex, ControlEp* ctlEp);
    uint8_t bEndpointAddress; 
    uint16_t wMaxPacketSize;
    uint8_t FormatIndex;
    uint8_t FrameIndex;
    uint32_t dwFrameInterval;
    uint8_t bInterface;
    uint8_t bAlternate;
    uint16_t bcdUVC;
private:
    void _parserAudioControl(uint8_t* buf, int len);
    void _parserAudioStream(uint8_t* buf, int len);
    void _parserVideoControl(uint8_t* buf, int len);
    void _parserVideoStream(uint8_t* buf, int len);
    void _parserConfigurationDescriptor(uint8_t* buf, int len);
    uint16_t _width;
    uint16_t _height;
    uint8_t _payload;
    int _If;
    int _Ifalt;
    int _IfClass;
    int _IfSubClass;
    ControlEp* _ctlEp;
};

#endif //UVC_CAM_H
