// test_RomDisk.cpp 2013/9/24
#if 0
#include "mbed.h"
#include "USBMSD2.h"
#include "RomDisk.h"
#include "mytest.h"
#include "mydebug.h"

Serial pc(USBTX, USBRX);

class RomDisk1 : public USBMSD2 {
public:
    RomDisk1() {
        _sectors = 128; // 64KB(512*128)
        _status = 0x01;
        connect();
    }
    virtual int disk_initialize() {
        _status = 0x00;
        return 0;
    }
    virtual int disk_status() { return _status; }
    virtual int disk_read(uint8_t * data, uint64_t block) { return _disk.read(data, block); }
    virtual int disk_write(const uint8_t * data, uint64_t block) {
        if (_disk.is_data(block)) {
            DBG("block=%d", (int)block);
        }
        return _disk.write(data, block);
    }
    virtual uint64_t disk_sectors() { return _sectors; }
    virtual uint64_t disk_size() { return _sectors * 512; }
    
protected:
    RomDisk _disk;
    uint64_t _sectors;
    uint8_t _status;
};


TEST(RomDisk1,test1) {
    RomDisk1* intf = new RomDisk1();
    Timer t;
    t.reset();
    t.start();
    int n = 0;
    while(1) { // forever
        if (intf->readable()) {
            int c = intf->getc();
            debug("%02x[%c]\n", c, c > ' ' ? c : '.');
        }
        if (t.read_ms() > 1000*1) {
            t.reset();
            intf->putc('A'+ n%26);
            n++;
        }
    }
}

int main() {
    pc.baud(921600);
    //pc.baud(9600);
    DBG("%s", __FILE__);

    RUN_ALL_TESTS();
    exit(0);
}
#endif
