#pragma once

struct SectorData {
    SectorData* next;
    int block;
    uint8_t data[512];
};

class RamDisk {
public:
    RamDisk();
    int read(uint8_t * data, uint32_t block);
    int write(const uint8_t * data, uint32_t block);
    uint32_t sectors();

    void exportData(Stream* pc);
protected:
    SectorData* find(uint16_t block);
    SectorData* _head;
    int use_size;
    uint64_t _sectors;
};
