// RomDisk.cpp 2013/9/26
#include "mbed.h"
#include "RomDisk.h"

RomDisk::RomDisk()
{
    _sectors = 128; // 64KB(512*128)
}

int RomDisk::read(uint8_t * data, uint32_t block)
{
    SectorIndex* p = const_cast<SectorIndex*>(sector_index);
    while(p->data) {
        if (p->block == block) {
            memcpy(data, p->data, 512);
            return 0;
        }
        p++;    
    }
    memset(data, 0x00, 512);
    return 0;   
}

int RomDisk::write(const uint8_t * data, uint32_t block)
{
    return 0;
}

uint32_t RomDisk::sectors()
{
    return _sectors;
}

bool RomDisk::is_fat(uint32_t sector)
{
    return sector >= 6 && sector <= 7;
}

bool RomDisk::is_rootdir(uint32_t sector)
{
    return sector >= 8 && sector <= 15;
}

int RomDisk::dir_count(uint32_t sector)
{
    if (!is_rootdir(sector)) {
        return -1;
    }
    return sector - 8;
}

uint32_t RomDisk::cluster_to_sector(uint32_t cluster)
{
    return cluster + 38;
}
