// USBMSD_LPC.h 2013/9/26
#pragma once
#include "USBMSD_Drop.h"
#include "Target2.h"
#include "Flash.h"

/** drag-and-drop flash writer using the USBMSD class
 *
 * @code
 * #include "mbed.h"
 * #include "USBMSD_LPC.h"
 * Serial pc(USBTX, USBRX);
 * SWD swd(PTB8,PTB9,PTB10); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
 *
 * int main() {
 *     USBMSD_LPC* LPC1114 = new USBMSD_LPC(&swd, &pc); 
 *     while(1); // forever
 * }
 * @endcode
 */
class USBMSD_LPC : public USBMSD_Drop {
public:
    /** create drag-and-drop flash writer
     * @param swd SWD interface
     */
    USBMSD_LPC(SWD* swd, Serial* usbpc);
    virtual ~USBMSD_LPC() {}
    virtual void Drop(const uint8_t* data, int len, int offset, int total);
protected:
    Target2* _target;
    Flash* _flash;
    Serial* _pc;
};
