// Target2.h 2013/9/23
#pragma once
#include "mbed.h"
#include "SWD.h"

#define TARGET_RUNNING  (1<<0)
#define TARGET_HALTED   (1<<1)

class Target2;
class CoreReg {
public:
    void setup(Target2* target, uint8_t reg);
    uint32_t read();
    void write(uint32_t value);
    
    CoreReg& operator= (int value) {
        write(value);
        return *this;
    }

    CoreReg& operator= (CoreReg& rhs) {
        write(rhs.read());
        return *this;
    }

    operator uint32_t() {
        return read();
    }
protected:
    Target2* _target;
    uint8_t _reg;    
};

/** Target MCU interface
 */
class Target2 {
public:
    /** create target MCU interface
     * @param swdio SWD(swdio) pin
     * @param swclk SWD(swclk) pin
     * @param reset reset pin
     */
    Target2(PinName swdio, PinName swclk, PinName reset);

    /** create target MCU interface
     * @param swd SWD interface
     */
    Target2(SWD* swd);
    bool setup();
    void SWJClock(uint32_t clock_hz);
    uint32_t readMemory(uint32_t addr);
    void readMemory(uint32_t addr, uint32_t* data, int count);
    void writeMemory(uint32_t addr, uint32_t data);
    void writeMemory(uint32_t addr, uint32_t* data, int count);
    uint8_t readMemory8(uint32_t addr);
    void writeMemory8(uint32_t addr, uint8_t data);
    void halt();
    void resume();
    void step();
    void Abort();
    void HardwareReset();
    void SoftwareReset();
    int getStatus();
    bool wait_status(int status, int timeout_ms = 500);
    bool prog_status();
    bool setBreakpoint0(uint32_t addr);
    void removeBreakpoint0(uint32_t addr);

    CoreReg r0;
    CoreReg r1; 
    CoreReg r2; 
    CoreReg r3; 
    CoreReg r4; 
    CoreReg r5; 
    CoreReg r6; 
    CoreReg r7; 
    CoreReg r8; 
    CoreReg r9; 
    CoreReg r10; 
    CoreReg r11; 
    CoreReg r12; 
    CoreReg sp; 
    CoreReg lr; 
    CoreReg pc;
    CoreReg xpsr;
    
    uint32_t idcode;
protected:
    void inst();
    void _setaddr(uint32_t addr); 
    void _setaddr8(uint32_t addr); 
    void JTAG2SWD();

    SWD* _swd;
};
