// test_USBMSD2_HID.cpp 2013/9/28
#if 0
#include "mbed.h"
#include "USBMSD_Drop.h"
#include "BaseDAP.h"
#define MY_DEBUG 1
#include "mydebug.h"
#include "mytest.h"

Serial pc(USBTX, USBRX);

#ifdef TARGET_LPC1768
Serial target_uart(p9,p10); // RXD(dp15),TXD(dp16)
SWD swd(p21,p22,p17); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
DigitalOut connected(LED1);
DigitalOut running(LED2);
class myDAP : public BaseDAP {
public:
    myDAP(SWD* swd):BaseDAP(swd){};
    virtual void infoLED(int select, int value) {
        switch(select) {
            case 0: connected = value; break;
            case 1: running = value; break;
        }
    } 
};
#endif

#ifdef TARGET_KL25Z
SWD swd(PTB8,PTB9,PTB10); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
DigitalOut connected(LED_GREEN);
DigitalOut running(LED_RED);
class myDAP : public BaseDAP {
public:
    myDAP(SWD* swd):BaseDAP(swd){};
    virtual void infoLED(int select, int value) {
        switch(select) {
            case 0:
                connected = value^1; 
                running = 1;
                break;
            case 1: 
                running = value^1; 
                connected = 1;
                break;
        }
    } 
};
#endif

class myUSBMSD_Drop : public USBMSD_Drop {
public:
    virtual void Drop(const uint8_t* data, int len, int offset, int total) {
        TEST_PRINT("offset=%d, total=%d", offset, total);
    }
};

HID_REPORT send_report;
HID_REPORT recv_report;

myDAP* dap;
myUSBMSD_Drop* hid;

TEST(USBMSD2_HID,test1) {
    dap = new myDAP(&swd);
    hid = new myUSBMSD_Drop();
}

#if 0
TEST(USBMSD2_HID,test2) {
    while(1) { // forever
        if(hid->readNB(&recv_report)) {
            dap->Command(recv_report.data, send_report.data);
            send_report.length = 64;
            hid->send(&send_report);
        }
    }
}
#endif

TEST(USBMSD2_HID,test3) {
    while(1) { // forever
        if(hid->readNB(&recv_report)) {
            dap->Command(recv_report.data, send_report.data);
            send_report.length = 64;
            hid->send(&send_report);
        }
#ifdef TARGET_LPC1768
        if (target_uart.readable()) {
            hid->putc(target_uart.getc());
        }
        if(hid->readable()) {
            target_uart.putc(hid->getc());
        }
#endif        
    }
}

int main() {
    pc.baud(921600);
    //pc.baud(9600);
    DBG("%s", __FILE__);

    RUN_ALL_TESTS();
    exit(0);
}
#endif
