// RamDisk.cpp 2013/9/21
#include "mbed.h"
#include "RamDisk.h"
#include "mydebug.h"

RamDisk::RamDisk() : _head(NULL), use_size(0)
{
    _sectors = 128; // 64KB(512*128)
}

int RamDisk::read(uint8_t * data, uint32_t block)
{
    //DBG("block=%d", block);
    SectorData* p = find(block);
    if (p) {
        memcpy(data, p->data, 512);
        return 0;
    }
    memset(data, 0x00, 512);
    return 0;   
}

static bool is_blank(const uint8_t* data)
{
    for(int i = 0; i < 512; i++) {
        if (data[i]) {
            return false;
        }
    }
    return true;
}

int RamDisk::write(const uint8_t * data, uint32_t block)
{
    SectorData* p = find(block);
    if (p) {
        DBG("update block=%d", block);
        memcpy(p->data, data, 512);
        return 0;
    }
    if (is_blank(data)) {
        return 0;
    }   
    DBG("new block=%d", block);
    p = new SectorData;
    TEST_ASSERT(p);
    p->block = block;
    memcpy(p->data, data, 512);
    p->next = _head;
    _head = p;
    use_size += 512;
    //DBG("use_size: %d", use_size);
    TEST_ASSERT(use_size < (512*16));
    return 0;
}

uint32_t RamDisk::sectors()
{
    return _sectors;
}

SectorData* RamDisk::find(uint16_t block)
{
    SectorData* p = _head;
    while(p) {
        if (p->block == block) {
            break;
        }
        p = p->next;
    }
    return p;
}

void RamDisk::exportData(Stream* pc)
{
    pc->printf("\n\n\n\n\n");
    SectorData* p = _head;
    while(p) {
        pc->printf("const uint8_t sector_%d[] = {\n", p->block);
        for(int i = 0; i < 512; i++) {
            pc->printf("0x%02x,", p->data[i]);
            if (i%16 == 15) {
                pc->printf("\n");
            }
        }
        pc->printf("};\n");
        p = p->next;
    }

    pc->printf("const SectorIndex sector_index[] = {\n");
    p = _head;
    while(p) {
        pc->printf("{%d, sector_%d},\n", p->block, p->block); 
        p = p->next;
    }
    pc->printf("{-1, NULL},\n");
    pc->printf("};\n");
    pc->printf("\n\n\n\n\n");
}
