// USBMSD_Drop.h 2013/9/26
#pragma once
#include "USBMSD.h"
#include "USBMSD2.h"
#include "RomDisk.h"

#ifdef TARGET_LPC1768
#define USBMSD USBMSD2
#endif 

/** drag-and-drop using the USBMSD class
 *
 * @code
 * #include "mbed.h"
 * #include "USBMSD_Drop.h"
 * Serial pc(USBTX, USBRX);
 * USBMSD_Drop* host;
 * 
 * void callback(const uint8_t* data, int len, int offset, int total)
 * {
 *     for(int i = 0; i < len && (offset+i) < total; i++) {
 *         pc.putc(data[i]);
 *     }
 * }
 * 
 * int main() {
 *     host = new USBMSD_Drop();
 *     host->attach(callback);
 *     while(1); // forever
 * }
 * @endcode
 */
class USBMSD_Drop : public USBMSD {
public:
    /** create drag-and-drop file transfer
     */
    USBMSD_Drop();
    virtual ~USBMSD_Drop() {}

    /** drag-and-drop file received
     *
     * @param data received data pointer
     * @param len data length
     * @param offset offset from file top
     * @param total total file size
     */
    virtual void Drop(const uint8_t* data, int len, int offset, int total){};

    /**
     * Attach a callback for when a file is received
     *
     * @param fptr function pointer
     */
    void attach(void (*fptr)(const uint8_t* data, int len, int offset, int total));
protected:
    virtual int disk_initialize();
    virtual int disk_status();
    virtual int disk_read(uint8_t * data, uint64_t block);
    virtual int disk_write(const uint8_t * data, uint64_t block);
    virtual uint64_t disk_sectors();
    virtual uint64_t disk_size();
    uint8_t _status;

    void _drop(const uint8_t* data, int len, int offset, int total);
    void (*_drop_evt)(const uint8_t* data, int len, int offset, int total);
    
    DirEntry* findNewFile(const uint8_t* data, uint32_t block);
    DirEntry _dir_entry;
    DirEntry* _result;
    DirEntry* _file;
    RomDisk _disk;
    int _seq;
    int _prev_block;
    int _addr;
};
