// main.cpp 2013/9/28
#if 1
#include "mbed.h"
#include "USBMSD_LPC.h"
#include "BaseDAP.h"

Serial pc(USBTX, USBRX);

#ifdef TARGET_KL25Z
SWD swd(PTB8,PTB9,PTB10); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
#endif

#ifdef TARGET_LPC1768
SWD swd(p21,p22,p17); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
Serial target_uart(p9,p10); // RXD(dp15),TXD(dp16)
DigitalOut connected(LED1);
DigitalOut running(LED2);
class myDAP : public BaseDAP {
public:
    myDAP(SWD* swd):BaseDAP(swd){};
    virtual void infoLED(int select, int value) {
        switch(select) {
            case 0: connected = value; break;
            case 1: running = value; break;
        }
    } 
}* dap = NULL;
HID_REPORT send_report;
HID_REPORT recv_report;
#endif

int main() {
    USBMSD_LPC* device = new USBMSD_LPC(&swd, &pc); 
    while(1) {
#ifdef TARGET_LPC1768 
        if (target_uart.readable()) {
            device->putc(target_uart.getc());
        }
        if(device->readable()) {
            target_uart.putc(device->getc());
        }

        if (dap == NULL) {
            dap = new myDAP(&swd);
        }
        if(device->readNB(&recv_report)) {
            dap->Command(recv_report.data, send_report.data);
            send_report.length = 64;
            device->send(&send_report);
        }
#endif
    }
}

#endif
