// USBMSD_LPC.cpp 2013/9/28
#include "mbed.h"
#include "USBMSD_LPC.h"
#define MY_DEBUG
#include "mydebug.h"

#ifdef TARGET_LPC1768
#define LED_ON  1
#define LED_OFF 0
#endif
#ifdef TARGET_KL25Z
#define LED_ON  0
#define LED_OFF 1
#endif
DigitalOut led3(LED3);

USBMSD_LPC::USBMSD_LPC(SWD* swd, Serial* usbpc) : _pc(usbpc)
{
    _target = new Target2(swd);
    _flash = NULL;
    led3 = LED_OFF;
}

/* virtual */ void USBMSD_LPC::Drop(const uint8_t* data, int len, int offset, int total)
{
    if (_flash == NULL) {
        _target->setup();
        _flash = new Flash(_target, _pc);
    }    
    DBG("%d/%d", offset, total);
    if (offset == 0) {
        _flash->init();
        _flash->eraseAll();
        led3 = LED_ON;
    }
    _flash->write(offset, data, len);
    led3 = !led3;
    if (offset+len >= total) {
        led3 = LED_OFF;
        delete _flash;
        _flash = NULL;
        _target->SoftwareReset();
        _target->setup();
    }
}
