// RomDisk.h 2013/9/26
#pragma once

#define ATTR_READ_ONLY 0x01
#define ATTR_HIDDEN    0x02
#define ATTR_SYSTEM    0x04
#define ATTR_VOLUME_ID 0x08
#define ATTR_DIRECTORY 0x10
#define ATTR_ARCHIVE   0x20
#define ATTR_LONG_NAME (ATTR_READ_ONLY|ATTR_HIDDEN|ATTR_SYSTEM|ATTR_VOLUME_ID)

struct DirEntry {
    uint8_t name[8+3];
    uint8_t attr;
    uint8_t NTres;
    uint8_t cDateTime_ms;
    uint16_t cTime;
    uint16_t cDate;
    uint16_t aDate;
    uint16_t clusterHI;
    uint16_t mTime;
    uint16_t mDate;
    uint16_t cluster;
    uint32_t size;
    bool is_free() {
        return name[0] == 0xe5 || name[0] == 0x00;
    }
    bool is_file() {
        return is_free() == false && attr == ATTR_ARCHIVE;
    }
    int cmpDateTime(DirEntry* entry) {
        if (mDate > entry->mDate) {
            return 1;
        } else if (mDate < entry->mDate) {
            return -1;
        }
        if (mTime > entry->mTime) {
            return 1;
        } else if (mTime < entry->mTime) {
            return -1;
        }
        return 0;
    }
} __attribute__((__packed__));;

struct SectorIndex {
    int block;
    const uint8_t* data;
};

extern const SectorIndex sector_index[]; // RomDiskData.cpp

class RomDisk {
public:
    RomDisk();
    int read(uint8_t * data, uint32_t block);
    int write(const uint8_t * data, uint32_t block);
    uint32_t sectors();
    bool is_fat(uint32_t sector);
    bool is_rootdir(uint32_t sector);
    int dir_count(uint32_t sector);
    uint32_t cluster_to_sector(uint32_t cluster);
protected:
    uint64_t _sectors;
};
