// Flash.h 2013/9/16
#pragma once
#include "Target2.h"

#define IAP_CCLK 12000

/** Flash writer
 */
class Flash {
public:
    Flash(Target2* target, Serial* usbpc);
    bool init();
    bool write(const char* filename);
    bool write(int addr, const uint8_t* data, int size);
    bool eraseAll();
    bool verify(const char* filename);
    enum IAP_CMD {
        PREPARE_SECTOR = 50,
        COPY_RAM_TO_FLASH = 51,
        ERASE_SECTOR = 52,
        BLANK_CHECK = 53,
        READ_PART_ID = 54,
        READ_BOOT_CODE_VERSION = 55,
        COMPARE = 56,
        REINVOKE_ISP = 57,
        READ_UID = 58,
    };
    enum IAP_STATUS {
        CMD_SUCCESS = 0,
        INVALID_COMMAND =1,
        SRC_ADDR_ERROR = 2,
        DST_ADDR_ERROR = 3,
        SRC_ADDR_NOT_MAPPED = 4,
        DST_ADDR_NOT_MAPPED = 5,
        COUNT_ERROR = 6,
        INVALID_SECTOR = 7,
        SECTOR_NOT_BLANK = 8,
        SECTOR_NOT_PREPARED_FOR_WRITE_OPERATION = 9,
        COMPARE_ERROR = 10,
        BUSY = 11,
        ADDR_ERROR = 13,
    };
    IAP_STATUS remoteIAP(IAP_CMD cmd, uint32_t p0=0, uint32_t p1=0, uint32_t p2=0, uint32_t p3=0);
private:
    void _setup();
    bool _write_to_ram(int addr, int size, const uint8_t* buf);
    int _sector(int addr);
    bool _patch(uint8_t* buf, int size, int addr);
protected:
    Target2* _target;
    Serial* _pc;
};
