; lowspeed.s 2013/4/29
;
        AREA    LOWSPEED,CODE,READONLY

; Base addresses
LPC_GPIO_BASE   EQU     0x2009c000

; GPIOs                                                                      */
LPC_GPIO0_BASE  EQU     (LPC_GPIO_BASE + 0x00000)
LPC_GPIO1_BASE  EQU     (LPC_GPIO_BASE + 0x00020)
LPC_GPIO2_BASE  EQU     (LPC_GPIO_BASE + 0x00040)
LPC_GPIO3_BASE  EQU     (LPC_GPIO_BASE + 0x00060)
LPC_GPIO4_BASE  EQU     (LPC_GPIO_BASE + 0x00080)

; offset
FIOPIN      EQU     0x14
FIOPIN0     EQU     0x14
FIOPIN1     EQU     0x15
FIOPIN2     EQU     0x16
FIOPIN3     EQU     0x17
FIOSET      EQU     0x18
FIOSET0     EQU     0x18
FIOSET1     EQU     0x19
FIOSET2     EQU     0x1a
FIOSET3     EQU     0x1b
FIOCLR      EQU     0x1c
FIOCLR0     EQU     0x1c
FIOCLR1     EQU     0x1d
FIOCLR2     EQU     0x1e
FIOCLR3     EQU     0x1f

; FIOSET2,FIOCLR2
P1_18   EQU     (1<<2)
P1_20   EQU     (1<<4)
; FIOPIN0
P2_4    EQU     (1<<4)
P2_5    EQU     (1<<5)

LED1    EQU     P1_18
LED2    EQU     P1_20
p21     EQU     P2_5
p22     EQU     P2_4            

USB_MASK    EQU     (p21+p22)
USB_SE0     EQU     (p21+p22)
;
; uint8_t* capraw(uint8_t* buf, int size, int count)
;
        EXPORT    capraw
capraw
        PUSH    {r4-r7}
        LDR     r6,=LPC_GPIO1_BASE
        MOV     r7,#LED1
cap10   LDR     r4,=LPC_GPIO2_BASE+FIOPIN0 ; D+ p21(P2_5), D- p22(P2_4)
cap20   LDRB    r5,[r4]
        TST     r5,#p21
        BEQ     cap20
        STRB    r7,[r6,#FIOSET2] ; LED1 on
cap50   LDRB    r5,[r4]
        STRB    r5,[r0],#+1
        TST     r5,#USB_SE0 ; EOP ?
        BNE     cap70
        STRB    r7,[r6,#FIOCLR2] ; LED1 off
        SUBS    r2,r2,#1
        BEQ     cap90
        B       cap10
cap70   SUBS    r1,r1,#1    ; buffer full ?
        BNE     cap50
cap90   POP     {r4-r7}        
        BX      lr 
        
        ALIGN
        END
 