// main.cpp 2013/4/29
#include "mbed.h"
#include "mbed_debug.h"
#include "usbpkt.h"

DigitalIn usb_data_p(p21); // USB DATA+ 
DigitalIn usb_data_m(p22); // USB DATA-
DigitalOut led_usb(LED1);

#define DISP_RAW 0
#define BUFFER_SIZE (1024*16)
#define MAX_PACKET_COUNT 35

#define USB_MASK (3<<4)
#define USB_DATA (2<<4)

DigitalOut led_run(LED4);
Serial pc(USBTX, USBRX);

extern "C" {
    uint8_t* capraw(uint8_t* buf, int size, int count); // lowspeed.s
}

uint8_t buf[BUFFER_SIZE];

int main() {
    pc.baud(921600);
    debug("%s\n", __FILE__);

    usb_data_p.mode(PullNone);
    usb_data_m.mode(PullNone);

    while(1) {
        uint8_t* ret = capraw(buf, sizeof(buf)-16, MAX_PACKET_COUNT);
        usbpkt pkt;
        pkt.reset();
        uint8_t* p = buf;
        while(p < ret) {
            uint8_t d = *p++;
            if ((d&USB_MASK) == 0) { // EOP ?
                debug_if(DISP_RAW, "\n");
                //pkt.printHEX(stdout);
                pkt.printUSB(stdout);
                pkt.reset();
            } else {
                pkt.inputRaw((d&USB_DATA) ? 1 : 0);
                debug_if(DISP_RAW, "%c", (d&USB_DATA) ? '*' : '.');
            }
        }
        debug("\n");
        wait_ms(200);
        led_run = !led_run;
    }
}
