#pragma once
#include "mbed.h"
#include "FATFileSystem.h"
#include "USBMSD.h"
#include "USBMSD2.h"
#include "StorageInterface.h"
#include "mystring.h"

class LocalStorage : public FATFileSystem {
public:
    LocalStorage(StorageInterface* storage, const char* name = "local");
    virtual int disk_read(uint8_t * buffer, uint64_t sector) {
        return _storage->storage_read(buffer, sector);
    }
    virtual int disk_write(const uint8_t * buffer, uint64_t sector) {
        return _storage->storage_write(buffer, sector);
    }
    virtual uint64_t disk_sectors() {
        return _storage->storage_sectors();
    }
    static bool find(char* buf, size_t size, const char* dirname, const char* pat);

private:
    StorageInterface* _storage;
    const char* _name;
};

class USBStorage : public USBMSD {
public:
    USBStorage(StorageInterface* storage): _storage(storage) {
        connect();
    }
    virtual int disk_read(uint8_t * data, uint64_t block) {
        return _storage->storage_read(data, block);
    }
    virtual int disk_write(const uint8_t * data, uint64_t block) {
        return _storage->storage_write(data, block);
    }
    virtual int disk_initialize() { return 0; }
    virtual uint64_t disk_sectors() {
        return _storage->storage_sectors();
    }
    virtual int disk_status() { return 0; }
    virtual uint64_t disk_size() {
        return _storage->storage_size();
    }

private:
    StorageInterface* _storage;
};

class USBStorage2 : public USBMSD2 {
public:
    USBStorage2(StorageInterface* storage): _storage(storage) {
        init();
        connect();
    }
    void init() {
        block_flag = false;
        report_block_count = 0;
        report_initialize_count = 0;
        report_read_count = 0;
        report_write_count = 0;
        report_sectors_count = 0;
        report_status_count = 0;
        report_size_count = 0;
    }
    virtual int disk_read(uint8_t * data, uint64_t block) {
        if (block_flag) {
            report_block_count++;
            return 1;
        }
        report_read_count++;
        return _storage->storage_read(data, block);
    }
    virtual int disk_write(const uint8_t * data, uint64_t block) {
        if (block_flag) {
            report_block_count++;
            return 1;
        }
        report_write_count++;
        return _storage->storage_write(data, block);
    }
    virtual int disk_initialize() {
        report_initialize_count++;
        return 0;
    }
    virtual uint64_t disk_sectors() {
        report_sectors_count++;
        return _storage->storage_sectors();
    }
    virtual int disk_status() {
        report_status_count++;
        return 0;
    }
    virtual uint64_t disk_size() {
        report_size_count++;
        return _storage->storage_size();
    }

    bool block(bool flag) {
        if (block_flag != flag) {
            block_flag = flag;
            return true;
        }
        return false;
    }
    __IO bool block_flag;
    __IO int report_block_count;
    __IO int report_initialize_count;
    __IO int report_read_count;
    __IO int report_write_count;
    __IO int report_sectors_count;
    __IO int report_status_count;
    __IO int report_size_count;

private:
    StorageInterface* _storage;
};

