#include "mbed.h"
#include "StorageInterface.h"
#include "SWSPI.h"

class SDStorage : public StorageInterface {
public:
    SDStorage(PinName mosi, PinName miso, PinName sclk, PinName cs);

    virtual int storage_read(uint8_t* data, uint32_t block);
    virtual int storage_write(const uint8_t* data, uint32_t block);
    virtual uint32_t storage_sectors();
    virtual uint32_t storage_size();

    int storage_initialize();

protected:
    int _cmd(int cmd, int arg);
    int _cmdx(int cmd, int arg);
    int _cmd8();
    int _cmd58();
    int initialise_card();
    int initialise_card_v1();
    int initialise_card_v2();
    
    int _read(uint8_t * buffer, uint32_t length);
    int _write(const uint8_t *buffer, uint32_t length);
    uint64_t _sd_sectors();
    uint64_t _sectors;
    SWSPI _spi;
    DigitalOut _cs;
    int cdv;
};
