// DiskInterface.h 2013/9/21
#pragma once

class DiskInterface {
public:
    /*
    * read a block on a storage chip
    *
    * @param data pointer where will be stored read data
    * @param block block number
    * @returns 0 if successful
    */
    virtual int disk_read(uint8_t * data, uint64_t block) = 0;

    /*
    * write a block on a storage chip
    *
    * @param data data to write
    * @param block block number
    * @returns 0 if successful
    */
    virtual int disk_write(const uint8_t * data, uint64_t block) = 0;

    /*
    * Disk initilization
    */
    virtual int disk_initialize() = 0;

    /*
    * Return the number of blocks
    *
    * @returns number of blocks
    */
    virtual uint64_t disk_sectors() = 0;

    /*
    * Return memory size
    *
    * @returns memory size
    */
    virtual uint64_t disk_size() = 0;

    /*
    * To check the status of the storage chip
    *
    * @returns status: 0: OK, 1: disk not initialized, 2: no medium in the drive, 4: write protected
    */
    virtual int disk_status() = 0;
};
