#include "USBHostRSSI.h"

DigitalOut led1(LED1);

void callback(inquiry_with_rssi_info* info) {
    static int n = 0;
    char buf[18];
    info->bdaddr.str(buf, sizeof(buf));
    printf("%d %s %d\n", n++, buf, info->rssi);
    led1 = !led1;
}

int main() {
    USBHostRSSI bt;
    if (!bt.connect()) {
        error("USB Bluetooth dongle not found.\n");
    }
    bt.attachEvent(callback);
    while(1) {
        USBHost::poll();
    }
}

