#pragma once
#include "mbed.h"
#include "USBCDC.h"
#include "CircBuffer.h"

typedef enum {
    _USB,_UART,
} src_t;

class BaseUsbUartBridge : public SerialBase, public USBCDC {
public:
    BaseUsbUartBridge(PinName tx, PinName rx, int uart_buf_size = 256, int usb_buf_size = 1024);
    void poll();

protected:
    virtual bool EP2_OUT_callback() { return bulk_callback(); }
    virtual void lineCodingChanged(int baud, int bits, int parity, int stop);
    virtual void sendBreak(uint16_t duration);
    virtual void controlLineStateChanged(int rts, int dtr){}
    virtual void monitor(src_t src, uint8_t c) {}

private:
    bool bulk_callback();
    void uart_handler(void);
    CircBuffer<uint8_t> uart_buf;
    CircBuffer<uint8_t> usb_buf;
};

