// main.cpp 2015/7/8
// USB-to-UART-bridge
#include "BaseUsbUartBridge.h"

DigitalInOut uart_nRTS(p5);
DigitalInOut uart_nDTR(p6);
#if defined(TARGET_MCU_LPC11U35_501)
DigitalOut led_uart(LED1);
DigitalOut led_usb(LED2);
DigitalOut led_rts(p18);
DigitalOut led_dtr(p20);
#else
DigitalOut led_uart(LED1);
DigitalOut led_usb(LED2);
DigitalOut led_rts(LED3);
DigitalOut led_dtr(LED4);
#endif

class USB_UART : public BaseUsbUartBridge {
public:
    USB_UART(PinName tx, PinName rx) : BaseUsbUartBridge(tx, rx) {
        uart_nRTS.mode(PullUp);
        uart_nDTR.mode(PullUp);
        uart_nRTS.input();        
        uart_nDTR.input();
    }
    virtual void controlLineStateChanged(int rts, int dtr) {
        led_rts = rts;
        led_dtr = dtr;
        if (rts) {
            uart_nRTS.output();
            uart_nRTS = 0;
        } else {
            uart_nRTS.input();
        }
        if (dtr) {
            uart_nDTR.output();
            uart_nDTR = 0;
        } else {
            uart_nDTR.input();
        }
    }
    virtual void monitor(src_t src, uint8_t c) {
        switch(src) {
            case _UART: led_uart = !led_uart; break;
            case _USB: led_usb = !led_usb; break;
        }
    }
} usb_uart(UART_TX, UART_RX);

int main() {
    while(1) {
        usb_uart.poll();
    }
}
