#include "BaseUsbUartBridge.h"

// http://mbed.org/handbook/USBSerial
// http://mbed.org/media/uploads/samux/serial.zip

BaseUsbUartBridge::BaseUsbUartBridge(PinName tx, PinName rx, int uart_buf_size, int usb_buf_size)
    : SerialBase(tx, rx), USBCDC(0x1f00, 0x2012, 0x0001, true),
    uart_buf(uart_buf_size), usb_buf(usb_buf_size)
{
    SerialBase::attach(this, &BaseUsbUartBridge::uart_handler, RxIrq);
}

void BaseUsbUartBridge::poll()
{
    uint8_t c;
    int size = uart_buf.available();
    if (size > 0) {
        uint8_t buf[MAX_PACKET_SIZE_EPBULK];
        if (size > sizeof(buf)) {
            size = sizeof(buf);
        }
        for(int i = 0; i < size; i++) {
            uart_buf.dequeue(&c);
            buf[i] = c;
            monitor(_UART, c);
        }
        if (terminal_connected) {
            USBCDC::send(buf, size);
        }
    }
    
    if (usb_buf.dequeue(&c)) {
        SerialBase::_base_putc(c);
        monitor(_USB, c);
    }
}

void BaseUsbUartBridge::uart_handler(void)
{
    uint8_t c = SerialBase::_base_getc();
    uart_buf.queue(c);
}

bool BaseUsbUartBridge::bulk_callback()
{
    uint8_t c[65];
    uint32_t size = 0;

    //we read the packet received and put it on the circular buffer
    readEP(c, &size);
    for (uint32_t i = 0; i < size; i++) {
        usb_buf.queue(c[i]);
    }

    // We reactivate the endpoint to receive next characters
    readStart(EPBULK_OUT, MAX_PACKET_SIZE_EPBULK);
    return true;    
}

/* virtual */ void BaseUsbUartBridge::lineCodingChanged(int baud, int bits, int parity, int stop)
{
    SerialBase::baud(baud);
}

/* virtual */ void BaseUsbUartBridge::sendBreak(uint16_t duration)
{
    SerialBase::send_break();
};

