#include "mbed.h"
#include "USBDAP.h"
#include "BaseDAP.h"

#if defined(TARGET_MCU_LPC11U35_501)
SWD swd(p6, p8, p30); // SWDIO,SWCLK,nRESET
DigitalOut connected(LED1);
DigitalOut running(LED2);
#else
SWD swd(D12, D10, D6); // SWDIO,SWCLK,nRESET
DigitalOut connected(LED_GREEN);
DigitalOut running(LED_RED);
#endif

class myDAP : public BaseDAP {
public:
    myDAP(SWD* swd):BaseDAP(swd){};
    virtual void infoLED(int select, int value) {
        switch(select) {
            case 0:
                connected = value^1; 
                running = 1;
                break;
            case 1: 
                running = value^1; 
                connected = 1;
                break;
        }
    } 
};

int main() {
   USBDAP* hid = new USBDAP("CMSIS-DAP");
   myDAP* dap = new myDAP(&swd);
   while(1) {
        HID_REPORT recv_report;
        if(hid->readNB(&recv_report)) {
            HID_REPORT send_report;
            dap->Command(recv_report.data, send_report.data);
            send_report.length = 64;
            hid->send(&send_report);
        }
    }    
}

