// SimpleJpegDecode_example/main.cpp 2013/2/2
// convert jpeg to bmp
//
#include "mbed.h"
#include "rtos.h"
#include "BaseUsbHost.h"
#include "SimpleJpegDecode.h"
#include "UsbFlashDrive.h"
#include "bmp24.h"

#define INPUT_FILE  "/usb/input.jpg"
#define OUTPUT_FILE "/usb/output.bmp"

Serial pc(USBTX, USBRX);

SimpleJpegDecode decode;
bmp24 bmp;

void callbackRGB(int x, int y, uint8_t* rgb)
{
    bmp.point(x, y, rgb);
}

int main() {
    pc.baud(921600);
    printf("%s\n", __FILE__);

    BaseUsbHost* usbHost = new BaseUsbHost();
    ControlEp* ctlEp = new ControlEp; // root hub
    if (UsbHub::check(ctlEp)) {
        UsbHub* hub = new UsbHub(ctlEp);
        ctlEp = hub->search<UsbFlashDrive>();
    }
    if (!UsbFlashDrive::check(ctlEp)) {
        error("USB flash drive is not connected.\n");
    }
    UsbFlashDrive* drive = new UsbFlashDrive("usb", ctlEp);

    bmp.clear();
    decode.setOnResult(callbackRGB);
    decode.clear();
    printf("input: %s\n", INPUT_FILE);
    FILE* fp = fopen(INPUT_FILE, "rb");
    if (fp == NULL) {
         error("open error\n");
    }
    while(!feof(fp)) {
        int c = fgetc(fp);
        decode.input(c);
    }
    fclose(fp);
    printf("output: %s\n", OUTPUT_FILE);
    if (!bmp.writeFile(OUTPUT_FILE)) {
        error("write error\n");
    }
    exit(1);     
}
