#if defined(TARGET_NUCLEO_L152RE)
#include "mbed.h"
#include "mytest.h"
#include "IAP.h"

DigitalOut led1(LED1);
RawSerial pc(USBTX,USBRX);
IAP iap;

void dump(const uint8_t* addr, size_t size = 32) {
    for(size_t i = 0; i < size; i++) {
        if (i%32 == 0) { printf("%p:", addr); }
        printf(" %02x%s", *addr++, i%32 == 31 ? "\n" : "");
    }
}

TEST(read_ID,test1) {
    int r = iap.read_ID();
    ASSERT_TRUE(r == 0x437); 
}

TEST(erase,page480) {
    int r = iap.erase(480, 480);
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t* p = (uint8_t*)0x801e000;
    dump((uint8_t*)0x801e000);
    for(int i = 0; i < 256; i++, p++) {
        ASSERT_TRUE(*p == 0x00);
    }
}

TEST(erase,page2047) {
    int r = iap.erase(2047, 2047);
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t* p = (uint8_t*)0x0807ff00;
    dump((uint8_t*)0x0807ff00);
    for(int i = 0; i < 256; i++, p++) {
        ASSERT_TRUE(*p == 0x00);
    }
}

TEST(erase,page2048) {
    int r = iap.erase(2048, 2048);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

TEST(blank_check,page480) {
    int r = iap.blank_check(480, 480);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,page2047) {
    int r = iap.blank_check(2047, 2047);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,page2048) {
    int r = iap.blank_check(2048, 2048);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

const uint8_t src[256] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28};
    
TEST(write,page480_0x0801e000) {
    ASSERT_TRUE(FLASH_PAGE_SIZE == sizeof(src));
    int r = iap.write((char*)src, (char*)0x0801e000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)0x0801e000, sizeof(src)) == 0);
}

TEST(erase,page480_481) {
    int r = iap.erase(480, 481);
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t* p = (uint8_t*)0x801e000;
    for(int i = 0; i < 256*2; i++, p++) {
        ASSERT_TRUE(*p == 0x00);
    }
}

TEST(blank_check,page480_481) {
    int r = iap.blank_check(480, 481);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(write_eeprom,_0x08080000) {
    int r = iap.write_eeprom((char*)src, (char*)0x08080000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src,(char*)0x08080000, sizeof(src)) == 0);
}

TEST(read_eeprom,_0x08080000) {
    int r = iap.write_eeprom((char*)src, (char*)0x08080000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t temp[sizeof(src)];
    r = iap.read_eeprom((char*)0x08080000, (char*)temp, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(temp, src, sizeof(src)) == 0);
}

TEST(write_eeprom,_0x08082000) {
    int r = iap.write_eeprom((char*)src, (char*)0x08082000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(read_eeprom,_0x08082000) {
    uint8_t temp[sizeof(src)];
    int r = iap.read_eeprom((char*)0x08082000, (char*)temp, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(temp, src, sizeof(src)) == 0);
}

TEST(read_eeprom,_0x08084000) {
    uint8_t temp[sizeof(src)];
    int r = iap.read_eeprom((char*)0x08084000, (char*)temp, sizeof(src));
    ASSERT_TRUE(r != CMD_SUCCESS);
}

TEST(eeprom,_0x08083f00) {
    int r = iap.write_eeprom((char*)src, (char*)0x08083f00, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t temp[sizeof(src)];
    r = iap.read_eeprom((char*)0x08083f00, (char*)temp, sizeof(temp));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(temp, src, sizeof(temp)) == 0);
}

TEST(write_eeprom,_0x08084000) {
    int r = iap.write_eeprom((char*)src, (char*)0x08084000, sizeof(src));
    ASSERT_TRUE(r != CMD_SUCCESS);
}
        
int main() {
    pc.baud(115200);
    printf("%s", __FILE__);

    RUN_ALL_TESTS();
    for(;;) {
        led1 = !led1;
        wait_ms(200);
    }
}
#endif // TARGET_NUCLEO_L152RE
