#if defined(TARGET_NUCLEO_L031K6)
#include "mbed.h"
#include "mytest.h"
#include "IAP.h"

DigitalOut led1(LED1);
RawSerial pc(USBTX,USBRX);
IAP iap;

void dump(const uint8_t* addr, size_t size = 32) {
    for(size_t i = 0; i < size; i++) {
        if (i%32 == 0) { printf("%p:", addr); }
        printf(" %02x%s", *addr++, i%32 == 31 ? "\n" : "");
    }
}

TEST(read_ID,test1) {
    int r = iap.read_ID();
    ASSERT_TRUE(r == 0x425); 
}

TEST(erase,page224) {
    int r = iap.erase(224, 224);
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t* p = (uint8_t*)0x08007000;
    dump((uint8_t*)0x08007000);
    for(int i = 0; i < 128; i++, p++) {
        ASSERT_TRUE(*p == 0x00);
    }
}

TEST(erase,page256) {
    int r = iap.erase(256, 256);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

TEST(blank_check,page224) {
    int r = iap.blank_check(224, 224);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,page256) {
    int r = iap.blank_check(256, 256);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

const uint8_t src[128] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28};
    
TEST(write,page224_0x08007000) {
    int r = iap.write((char*)src, (char*)0x08007000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    if (r == CMD_SUCCESS) {
        ASSERT_TRUE(memcmp(src, (void*)0x08007000, sizeof(src)) == 0);
    }
}

TEST(write,page255_0x08007f80) {
    int r = iap.erase(255, 255);
    ASSERT_TRUE(r == CMD_SUCCESS);    
    r = iap.blank_check(255, 255);
    ASSERT_TRUE(r == CMD_SUCCESS);
    r = iap.write((char*)src, (char*)0x08007f80, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    if (r == CMD_SUCCESS) {
        ASSERT_TRUE(memcmp(src, (void*)0x08007f80, sizeof(src)) == 0);
    }
}

TEST(write,page256_0x08008000) {
    int r = iap.prepare(256, 256);
    ASSERT_TRUE(r != CMD_SUCCESS); 
    r = iap.erase(256, 256);
    ASSERT_TRUE(r != CMD_SUCCESS);    
    r = iap.write((char*)src, (char*)0x08008000, sizeof(src));
    ASSERT_TRUE(r != CMD_SUCCESS);
}

TEST(erase,page224_225) {
    int r = iap.erase(224, 225);
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t* p = (uint8_t*)0x08007000;
    for(int i = 0; i < 128*2; i++, p++) {
        ASSERT_TRUE(*p == 0x00);
    }
}

TEST(blank_check,page224_225) {
    int r = iap.blank_check(224, 225);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(write_eeprom,_0x08080000) {
    int r = iap.write_eeprom((char*)src, (char*)0x08080000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    if (r == CMD_SUCCESS) { 
        ASSERT_TRUE(memcmp(src,(char*)0x08080000, sizeof(src)) == 0);
    }
}

TEST(read_eeprom,_0x08080000) {
    int r = iap.write_eeprom((char*)src, (char*)0x08080000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t temp[sizeof(src)];
    r = iap.read_eeprom((char*)0x08080000, (char*)temp, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    if (r == CMD_SUCCESS) {
        ASSERT_TRUE(memcmp(temp, src, sizeof(src)) == 0);
    }
}

TEST(eeprom,_0x080803f0) { // 0x0808003ff-0x080803ff
    const size_t size = 16;
    int r = iap.write_eeprom((char*)src, (char*)0x080803f0, size);
    ASSERT_TRUE(r == CMD_SUCCESS);
    uint8_t temp[size];
    r = iap.read_eeprom((char*)0x080803f0, (char*)temp, sizeof(temp));
    ASSERT_TRUE(r == CMD_SUCCESS);
    if (r == CMD_SUCCESS) {
        ASSERT_TRUE(memcmp(temp, src, sizeof(temp)) == 0);
    }
}

TEST(eeprom,_0x08080400) { // 0x080800400-0x0808040f
    const size_t size = 16;
    int r = iap.write_eeprom((char*)src, (char*)0x08080400, size);
    ASSERT_TRUE(r != CMD_SUCCESS);
    uint8_t temp[size];
    r = iap.read_eeprom((char*)0x08080400, (char*)temp, sizeof(temp));
    ASSERT_TRUE(r != CMD_SUCCESS);
}

int main() {
    pc.baud(115200);
    printf("%s", __FILE__);

    RUN_ALL_TESTS();
    for(;;) {
        led1 = !led1;
        wait_ms(200);
    }
}
#endif // TARGET_NUCLEO_L031K6
