#if defined(TARGET_NUCLEO_F411RE)
#include "mbed.h"
#include "mytest.h"
#include "IAP.h"

DigitalOut led1(LED1);
RawSerial pc(USBTX,USBRX);
IAP iap;

void dump(const uint8_t* addr, size_t size) {
    for(size_t i = 0; i < size; i++) {
        if (i%32 == 0) {
            printf("%p:", addr);
        }
        printf(" %02x", *addr);
        addr++;
        if (i%32 == 31) {
            printf("\n");
        }
    }
}

TEST(read_ID,_0x431) {
    int r = iap.read_ID();
    ASSERT_TRUE(r == 0x431); 
}

TEST(erase,sector2) {
    int r = iap.erase(2, 2);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,sector2) {
    int r = iap.blank_check(2, 2);
    //dump((const uint8_t*)0x8008000, 64);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,sector3_sector2) {
    int r = iap.blank_check(3, 2);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

TEST(blank_check,sector8) {
    int r = iap.blank_check(8, 8);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

uint8_t src[256];
    
TEST(write,sector2_0x08008000) {
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)0x08008000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)0x08008000, sizeof(src)) == 0);
}

TEST(erase,sector2_sector3) {
    int r = iap.erase(2, 3);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector4) {
    int r = iap.erase(4, 4);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector5) {
    int r = iap.erase(5, 5);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector6) {
    int r = iap.erase(6, 6);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector7) {
    int r = iap.erase(7, 7);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector8) {
    int r = iap.erase(8, 8);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

TEST(blank_check,sector2_sector7) {
    int r = iap.blank_check(2, 7);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,sector8_sector9) {
    int r = iap.blank_check(8, 9);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

TEST(write,sector2_0x0800bf00) {
    const int dst = 0x0800bf00;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector3_0x0800c000) {
    const int dst = 0x0800c000;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector3_0x0800ff00) {
    const int dst = 0x0800ff00;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector4_0x08010000) {
    const int dst = 0x08010000;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector4_0x0801ff00) {
    const int dst = 0x0801ff00;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector5_0x08020000) {
    const int dst = 0x08020000;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector5_0x0803ff00) {
    const int dst = 0x0803ff00;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector6_0x08040000) {
    const int dst = 0x08040000;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector6_0x0805ff00) {
    const int dst = 0x0805ff00;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector7_0x08060000) {
    const int dst = 0x08060000;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector7_0x0807ff00) {
    const int dst = 0x0807ff00;
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)dst, sizeof(src)) == 0);
}

TEST(write,sector8_0x08080000) {
    const int dst = 0x08080000;
    int r = iap.write((char*)src, (char*)dst, sizeof(src));
    ASSERT_TRUE(r != CMD_SUCCESS);
}

int main() {
    pc.baud(115200);
    printf("%s\n", __FILE__);

    RUN_ALL_TESTS();
    for(;;) {
        led1 = !led1;
        wait_ms(200);
    }
}
#endif // TARGET_NUCLEO_F411RE
