#if defined(TARGET_NUCLEO_F446RE)
#include "mbed.h"
#include "mytest.h"
#include "IAP.h"

DigitalOut led1(LED1);
RawSerial pc(USBTX,USBRX);
IAP iap;

void dump(const uint8_t* addr, size_t size) {
    for(size_t i = 0; i < size; i++) {
        if (i%32 == 0) { printf("%p:", addr); }
        printf(" %02x%s", *addr++, i%32 == 31 ? "\n" : "");
    }
}

TEST(read_ID,test1) {
    int r = iap.read_ID();
    ASSERT_TRUE(r == 0x421); 
}

TEST(erase,sector2) {
    int r = iap.erase(2, 2);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,sector2) {
    int r = iap.blank_check(2, 2);
    //dump((const uint8_t*)0x8008000, 64);
    ASSERT_TRUE(r == CMD_SUCCESS);
    r = iap.blank_check(3, 2);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

uint8_t src[256];
    
TEST(write,sector2_0x08008000) {
    for(int i = 0; i < sizeof(src); i++) {
        src[i] = i&0xff;
    }
    int r = iap.write((char*)src, (char*)0x08008000, sizeof(src));
    ASSERT_TRUE(r == CMD_SUCCESS);
    ASSERT_TRUE(memcmp(src, (void*)0x08008000, sizeof(src)) == 0);
}

TEST(erase,sector3) {
    int r = iap.erase(3, 3);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector4) {
    int r = iap.erase(4, 4);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector5) {
    int r = iap.erase(5, 5);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector6) {
    int r = iap.erase(6, 6);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector7) {
    int r = iap.erase(7, 7);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(erase,sector8) {
    int r = iap.erase(8, 8);
    ASSERT_TRUE(r != CMD_SUCCESS);
}

TEST(blank_check,sector3) {
    int r = iap.blank_check(3, 3);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,sector3_4) {
    int r = iap.blank_check(3, 4);
    ASSERT_TRUE(r == CMD_SUCCESS);
}

TEST(blank_check,sector3_7) {
    int r = iap.blank_check(3, 7);
    ASSERT_TRUE(r == CMD_SUCCESS);
}
        
int main() {
    pc.baud(115200);
    printf("%s", __FILE__);

    RUN_ALL_TESTS();
    for(;;) {
        led1 = !led1;
        wait_ms(200);
    }
}
#endif // TARGET_NUCLEO_F446RE
