#include "mbed.h"
#include "DeepPowerDown.h"

// LPC810 pinout
#define dp1 P0_5  // nRESET
#define dp2 P0_4  // WAKEUP
#define dp3       // SWCLK
#define dp4       // SWDIO
#define dp5 P0_1  // nISP
#define dp6       // VIN
#define dp7       // GND
#define dp8 P0_0

DigitalOut led1(dp8);

int main()
{
    led1 = 1;
    wait_ms(10);
    led1 = 0;

    int ms = 150;
    int cnt = DeepPowerDown::getData0();
    if (++cnt >= 4) {
        cnt = 0;
        ms = 1500; // 1.5sec
    }
    DeepPowerDown::setData0(cnt);
    DeepPowerDown::wakeupTimer_ms(ms);
    DeepPowerDown::wakeupPin(false);
    DeepPowerDown::entry();
    /* NOTREACHED */
}

