#pragma once

class DeepPowerDown {
public:
    static void wakeupTimer(uint32_t delay_sec) {
        wakeupTimer_ms(delay_sec * 1000);
    }

    static void wakeupTimer_ms(uint32_t delay_ms) {
        LPC_PMU->DPDCTRL |= (1<<2)|(1<<3); // enable low-power oscillator
        LPC_SYSCON->SYSAHBCLKCTRL |= 1<<9;
        LPC_WKT->CTRL = 0x03; // low power clock(10kHz)
        LPC_WKT->COUNT = delay_ms * (10000/1000);
    }

    static void wakeupPin(bool enable) {
        if (enable) {
            LPC_PMU->DPDCTRL &= ~(1<<1);
        } else {
            LPC_PMU->DPDCTRL |= (1<<1);
        }
    }

    static void setData0(uint32_t data) { LPC_PMU->GPREG0 = data; }
    static void setData1(uint32_t data) { LPC_PMU->GPREG1 = data; }
    static void setData2(uint32_t data) { LPC_PMU->GPREG2 = data; }
    static void setData3(uint32_t data) { LPC_PMU->GPREG3 = data; }

    static uint32_t getData0() { return LPC_PMU->GPREG0; }
    static uint32_t getData1() { return LPC_PMU->GPREG1; }
    static uint32_t getData2() { return LPC_PMU->GPREG2; }
    static uint32_t getData3() { return LPC_PMU->GPREG3; }

    static void entry() {
        LPC_PMU->PCON = 0x03|(1<<3); // Deep power-down mode setting
        SCB->SCR = 1<<2; // Deep sleep for ARM core
        __WFI();
        /* NOTREACHED */
    }

    static bool is_entry() {
        return (LPC_PMU->PCON & (1<<11)) ? true : false;
    }

    static void clear() {
        LPC_PMU->PCON &= ~(1<<11); // clear DPDFLAG
    }
};

