#include "USBHostCam.h"
RawSerial pc(USBTX, USBRX);

#if defined(TARGET_LPC4088)
#define IMAGE_BUF_SIZE (1024*48)
#elif defined(TARGET_LPC1768)
#define IMAGE_BUF_SIZE (1024*24)
#else
#error "target error"
#endif

uint8_t image_buf[IMAGE_BUF_SIZE];
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
#define LED_OFF 0
#define LED_ON  1

int main() {
    pc.baud(9600);
    led1 = led2 = LED_OFF;

    // Logitech C270
    USBHostCam* cam = new USBHostCam(_800x600);
    if (!cam->connect()) {
        error("WebCam not found.\n");
    }

    int pos = 0; 
    int size = 0;
    Timer t;
    for(int seq = 0;;) {
        int c = -1;
        if (pc.readable()) {
            c = pc.getc();
        }    
        switch(seq) {
            case 0:
                pc.printf("\nReady, please download JPEG using XMODEM from LPC4088.\n");
                t.start();
                seq++;
                break;
            case 1:
                if (c == 0x15) { // NAK
                    size = cam->readJPEG(image_buf, sizeof(image_buf));
                    pos = 0;
                    seq++;
                }
                break;
            case 2:
                if (pos >= size) {
                    pc.putc(0x04); // EOT
                } else {
                    pc.putc(0x01); // SOH
                    uint8_t block = pos/128 + 1;
                    pc.putc(block);
                    pc.putc(block ^ 0xff);
                    uint8_t checksum = 0x00;
                    for(int i = 0; i < 128; i++) {
                        uint8_t c = image_buf[pos + i];
                        checksum += c;
                        pc.putc(c);
                    }
                    pc.putc(checksum);
                }
                seq++;
                t.reset();
                led2 = !led2;
                break;
            case 3:
                if (c == 0x06) { // ACK
                    if (pos >= size) {
                        seq = 0;
                    } else {
                        pos += 128;
                        seq--;
                    }
                }
                break;
        }
        if (t.read_ms() > 15*1000) { // timeout
            t.reset();
            seq = 0;
        }
        cam->poll();
    }
}
