// USBIsochronous.h
#pragma once

class IsochronousEp : public USBEndpoint {
public:
    IsochronousEp(USBDeviceConnected* dev);
    void init2(uint8_t frameCount = 4, uint8_t queueLimit = HCTD_QUEUE_SIZE);
    void reset(int delay_ms = 100);
    HCITD* isochronousReceive(int timeout_ms);

private:
    HCITD* new_HCITD(IsochronousEp* obj);
    HCITD* get_queue_HCITD(int timeout_ms);
    int m_itd_queue_count;
    int m_itd_queue_limit;
    uint16_t m_FrameNumber;
    int m_FrameCount; // 1-8
    void enable();
};


