// BaseUseHostDebug.cpp 2014/4/21
#include "USBHost.h"
#include "BaseUsbHostDebug.h"

void print_td(FILE* stream, HCTD* td)
{
    if (td == NULL) {
        fprintf(stream, "TD %p:\n", td);
        return;
    }
    uint32_t* p = reinterpret_cast<uint32_t*>(td);
    fprintf(stream, "TD %p: %08X %08X %08X %08X", p, p[0], p[1], p[2], p[3]);
    fprintf(stream, " ep=%p\n", td->ep);
    uint8_t* bp = reinterpret_cast<uint8_t*>(p[1]);
    uint8_t* be = reinterpret_cast<uint8_t*>(p[3]);
    if (bp) {
        fprintf(stream, "BF %p:", bp);
        while(bp <= be) {
            fprintf(stream, " %02X", *bp);
            bp++;
        }
        fprintf(stream, "\n");
    } 
}

void print_ed(FILE* stream, HCED* ed)
{
    uint32_t* p = reinterpret_cast<uint32_t*>(ed);
    while(p) {
        fprintf(stream, "ED %p: %08X %08X %08X %08X\n", p, p[0], p[1], p[2], p[3]);
        HCTD* td = reinterpret_cast<HCTD*>(p[2] & ~3);
        HCTD* tdtail = reinterpret_cast<HCTD*>(p[1]);
        while(td != NULL && td != tdtail) {
            print_td(stream, td);
            td = td->Next;
        }
        p = reinterpret_cast<uint32_t*>(p[3]);
    }
}

void print_itd(FILE* stream, HCITD* itd)
{
    if (itd == NULL) {
        fprintf(stream, "ITD %p:\n", itd);
        return;
    }
    uint32_t* p = reinterpret_cast<uint32_t*>(itd);
    fprintf(stream, "ITD %p: %08X %08X %08X %08X", p, p[0], p[1], p[2], p[3]);
    fprintf(stream, " ep=%p\n", itd->ep);
    uint16_t* offset = reinterpret_cast<uint16_t*>(p+4);
    fprintf(stream, "ITD %p: %04X %04X %04X %04X %04X %04X %04X %04X\n", offset, 
        offset[0], offset[1], offset[2], offset[3], offset[4], offset[5], offset[6], offset[7]);
}

void print_ied(FILE* stream, HCED* ed)
{
    uint32_t* p = reinterpret_cast<uint32_t*>(ed);
    while(p) {
        fprintf(stream, "ED %p: %08X %08X %08X %08X\n", p, p[0], p[1], p[2], p[3]);
        HCITD* itd = reinterpret_cast<HCITD*>(p[2] & ~3);
        HCITD* itdtail = reinterpret_cast<HCITD*>(p[1]);
        while(itd != NULL && itd != itdtail) {
            print_itd(stream, itd);
            itd = itd->Next;
        }
        p = reinterpret_cast<uint32_t*>(p[3]);
    }
}

void print_bytes(FILE* stream, char* s, uint8_t* buf, int len)
{
    fprintf(stream, "%s %d:", s, len);
    for(int i = 0; i < len; i++) {
        fprintf(stream, " %02X", buf[i]);
    }
    fprintf(stream, "\n");
}

void print_hex(FILE* stream, uint8_t* p, int len)
{
    for(int i = 0; i < len; i++) {
        if (i%16 == 0) {
            fprintf(stream, "%p:", p);
        }
        fprintf(stream, " %02X", *p);
        p++;
        if (i%16 == 15) {
            fprintf(stream, "\n");
        }
    }
    fprintf(stream, "\n");
}

void assert_print(const char* pf, int line, const char* msg) {
    fprintf(stderr, "\n\n%s@%d %s ASSERT!\n\n", pf, line, msg);
    exit(1);
}

