; UsbCapture.s 2014/5/21
;
        AREA    USBCAPTURE,CODE,READONLY


; uint8_t* usbcapture_lpc1114(uint8_t* buf, uint8_t* end)
;
;[ADDR][OUT  ][SYNC] |1110}{0}{0}{0}{1|10}{0}{0}{0}{0}{0}{0}
;[ADDR][IN   ][SYNC] |0}{110}{10}{0}{1|10}{0}{0}{0}{0}{0}{0}
;[ADDR][SETUP][SYNC] |0}{0}{10}{110}{1|10}{0}{0}{0}{0}{0}{0}
;
;[data][DATA0][SYNC] |110}{0}{0}{0}{11|10}{0}{0}{0}{0}{0}{0}
;[data][DATA1][SYNC] |0}{10}{0}{10}{11|10}{0}{0}{0}{0}{0}{0}
;
;[EOP ][ACK  ][SYNC]  |110}{10}{0}{10}|{10}{0}{0}{0}{0}{0}{0}
;[EOP ][NAK  ][SYNC]  |0}{10}{110}{10}|{10}{0}{0}{0}{0}{0}{0}
;[EOP ][STALL][SYNC]  |0}{0}{0}{11110}|{10}{0}{0}{0}{0}{0}{0}
;
;{0}       :  32 cycle
;{10}      :  64 cycle
;{110}     :  96 cycle
;{1110}    : 128 cycle
;{11110}   : 160 cycle
;{111110}  : 192 cycle
;{1111110} : 224 cycle
;

        EXPORT    usbcapture_lpc1114

CYCLE   equ     32
GPIO1   equ     0x50010c00
CT16B1  equ     0x40010000
_IR     equ     0x00
_TC     equ     0x08
_CR0    equ     0x2c
CR0Int  equ     (1<<4)

; PID
ACK     equ     0x02
NAK     equ     0x0a
STALL   equ     0x0e
DATA0   equ     0x03
DATA1   equ     0x0b
IN      equ     0x09
OUT     equ     0x01
SETUP   equ     0x0d

        MACRO
        init_param
        LDR     r4, =GPIO1          ; USB_DM(P1_9),USB_DP(P1_8)
        LDR     r5, =CT16B1         ; CT16B1
        MOVS    r6, #CR0Int         ; CR0 interrupt mask
        MOVS    r3, #1              ; prev_CR0
        MEND

        MACRO
        save_raw
        STRB    r2,[r0]
        ADDS    r0, r0, #1
        MEND

        MACRO
        read
1       LDR     r2, [r5,#_IR]
        TST     r2, r6
        BEQ     %b1
        LDR     r2, [r5,#_CR0]
        STR     r6, [r5,#_IR]
        SUBS    r2, r2, r3
        ADDS    r3, r3, r2
        UXTB    r2, r2
        MEND

        MACRO
        readNB  $skip
        LDR     r2, [r5,#_IR]
        TST     r2, r6
        BEQ     $skip
        LDR     r2, [r5,#_CR0]
        STR     r6, [r5,#_IR]
        SUBS    r2, r2, r3
        ADDS    r3, r3, r2
        UXTB    r2, r2
        MEND

        MACRO
        read_TC
        LDR     r2, [r5,#_TC]
        SUBS    r2, r2, r3
        ADDS    r3, r3, r2
        UXTB    r2, r2
        MEND

        MACRO
        if_1bit_gt $goto
        CMP     r2, #CYCLE+CYCLE/2
        BGT     $goto
        MEND

        MACRO
        if_1bit_le $goto
        CMP     r2, #CYCLE+CYCLE/2
        BLE     $goto
        MEND

        MACRO
        if_2bit_le $goto
        CMP     r2, #CYCLE*2+CYCLE/2
        BLE     $goto
        MEND

        MACRO
        if_3bit_le $goto
        CMP     r2, #CYCLE*3+CYCLE/2
        BLE     $goto
        MEND

        MACRO
        eopNB   $skip
        LDR     r2, [r4]            ; EOP(USB_DM=0,USB_DP=0) ?
        TST     r2, r2
        BNE     $skip               ; no
        MEND

usbcapture_lpc1114
CAPTURE PUSH    {r4-r7}
        init_param

SYNC
        read
        if_1bit_gt SYNC
        read
        if_1bit_gt SYNC
        read
        if_1bit_gt SYNC
SYNC_67bit
        read
        if_1bit_le SYNC_67bit
        if_2bit_le PID_ACK_NAK_STALL
        if_3bit_le PID_IN_OUT_SETUP

PID_DATA0_DATA1
        read
        if_1bit_le PID_DATA0

PID_DATA1
        read
        read
        MOVS    r2, #DATA1
        save_raw
        B       DATA_CRC16

PID_DATA0
        read
        read
        MOVS    r2, #DATA0
        save_raw
        B       DATA_CRC16

PID_ACK_NAK_STALL
        read
        if_2bit_le PID_ACK_NAK

PID_STALL
        read
        read
        MOVS    r2, #STALL
        save_raw
        B       EOP_WAIT

PID_ACK_NAK
        read
        if_1bit_le PID_ACK

PID_NAK
        read                ; 10b
        read                ; 0b
        MOVS    r2, #NAK
        save_raw
        B       EOP_WAIT

PID_ACK
        read
        MOVS    r2, #ACK
        save_raw
        B       EOP_WAIT

PID_IN_OUT_SETUP
        read
        if_1bit_le PID_IN_OUT

PID_SETUP
        read
        read
        MOVS    r2, #SETUP
        save_raw
        B       ADDR_ENDP_CRC5

PID_IN_OUT
        read
        if_1bit_le PID_OUT

PID_IN
        read
        MOVS    r2, #IN
        save_raw

DATA_CRC16
ADDR_ENDP_CRC5
20
        readNB  %f30
        save_raw
        CMP     r0, r1
        BGE     %f90                ; buffer full ?
        B       %b20
30
        eopNB   %b20
        STRB    r2, [r0,#1]
        read_TC
        STRB    r2, [r0,#0]
        ADDS    r0, r0, #2
        B       EOP

PID_OUT
        read
        MOVS    r2, #OUT
        save_raw
        B       ADDR_ENDP_CRC5

EOP_WAIT
10
        eopNB   %b10
        save_raw
        CMP     r0, r1
        BGE     EXIT
        B       SYNC
EOP
        CMP     r0, r1
        BGE     EXIT                ; buffer full ?
        B       SYNC
EXIT
90      POP     {r4-r7}
        BX      lr                  ; return, buf = r0 

ERROR   POP     {r4-r7}
        BX      lr

        ALIGN
        END

