#pragma once

typedef enum {
    ACK = 0x02,
    NAK = 0x0a,
    STALL = 0x0e,
    DATA0 = 0x03,
    DATA1 = 0x0b,
    IN = 0x09,
    OUT = 0x01,
    SETUP = 0x0d,
} pid_t;

typedef enum {
    SEQ_SYNC,
    SEQ_PID,
    SEQ_ADDR,
    SEQ_ENDP,
    SEQ_CRC5,
    SEQ_DATA,
    SEQ_CRC16,
} seq_t;

class BaseUsbProtocolAnalyzer {
public:
    BaseUsbProtocolAnalyzer();
    void init();
    void input(uint8_t data);
    bool disp_bit;
    bool disp_cycle;
protected:
    virtual void output(char c) = 0;

private:
    static const int CYCLE = 32;
    void inputBit(uint8_t pat, int len);
    void inputLSB(int lsb);
    void output(const char* s);
    bool bit_stuffing;
    seq_t seq;
    struct {
        pid_t pid;
        uint8_t addr;
        uint8_t endp;
        uint8_t crc5;
        uint8_t data[8+2]; // data and crc16
    } packet;
    int bit_count;
    int data_count;
};
