#include "mbed.h"
#include "BaseUsbProtocolAnalyzer.h"
//
//   USB    LPC1114FN28
// 1 VCC
// 2 DATA-  dp18(P1_9)
// 3 DATA+  dp17(P1_8)
// 4 GND    GND 

DigitalOut led1(LED1),led2(LED2);
DigitalIn usb_dm(P1_9);
DigitalIn usb_dp(P1_8);
RawSerial pc(USBTX, USBRX);

const int BUF_SIZE = 512;
uint8_t buf[BUF_SIZE+256];

class USB_Protocol_Analyzer : public BaseUsbProtocolAnalyzer {
    virtual void output(char c) {
        pc.putc(c);
    }
};

USB_Protocol_Analyzer analyzer;

extern "C" {
    uint8_t* usbcapture_lpc1114(uint8_t* buf, uint8_t* end);
}

void usbcapture_setup()
{
    usb_dm.mode(PullNone);
    usb_dp.mode(PullNone);

    LPC_SYSCON->SYSAHBCLKCTRL |= 1<<8; // CT16B1
    LPC_IOCON->PIO1_8 = (LPC_IOCON->PIO1_8 & ~0x7) | 0x1; // FUNC=CT16B1_CAP0
    LPC_TMR16B1->TCR |= 1; // Counter Enable
    LPC_TMR16B1->CCR |= 7; // CAP0RE,CAP0FE,CAP0I
}

int main() {
    pc.baud(115200);
    pc.puts(__FILE__);
    pc.puts("\n");

    usbcapture_setup();

    for(int n = 0; ; n++) {
        uint8_t* end = usbcapture_lpc1114(buf, buf+BUF_SIZE);
        analyzer.init();
        for(uint8_t* p = buf; p < end; p++) {
            analyzer.input(*p);
            if (*p == 0) {
                pc.puts("\n");
            }
        }
        pc.puts("\n\n");
        Timer t;
        t.reset();
        t.start();
        while(t.read_ms() < 1000*3 + n%100) {
        }
        led1 = !led1;
    }
}

