#pragma once

#include "mbed.h"
#include <stdarg.h>
#include "mystring.h"

#define LF '\n'
#define CRLF "\r\n"

#define LED_TX 0

class BaseLpcIsp {
public:
    BaseLpcIsp(PinName txd, PinName rxd, PinName reset, PinName isp):
         _target(txd, rxd),_nreset(reset),_nisp(isp) {
        _wpos = _rpos = 0;
        _target.attach<BaseLpcIsp>(this, &BaseLpcIsp::callback);
    };
    void Reset(bool isp);
    bool Sync();
    bool FlashWrite(const char* filename);

    void baud(int baudrate) { _target.baud(baudrate); }
    int putc(int c) { return _target.putc(c); }
    int readable() { return (_wpos != _rpos) ? 1 : 0; }
    int getc() {
        if (readable()) {
            int c = _buf[_rpos++];
            if (_rpos >= sizeof(_buf)) {
                _rpos = 0;
            }
            return c;
        }
        return -1;
    }
    int puts(const char *str) {
        while(*str) {
            putc(*str++);
        }
        return 0;
    }
    
protected:
    uint32_t part_code;
    int chunk_size;
    int sector_size;
    bool plan_binary;
    virtual void infoLED(int select, int value) {}
    virtual void infoSLCD(const char* s) {}

private:
    void isp_error(int line) {
        char buf[5];
        snprintf(buf, sizeof(buf), "E%3d", line);
        infoSLCD(buf);
    }
    bool _cmd(const char* format, ...);
    void sendln(const char* s);
    bool waitln(const char* s);
    bool recvln(char* buf, int size);
    bool recvln(mystring& s);
    bool _write_to_ram(int addr, uint8_t* buf, int size);
    bool _patch(int addr, uint8_t* buf, int size);
    RawSerial _target;
    char _buf[64];
    __IO int _wpos;
    int _rpos;
    void callback() {
        int c = _target.getc();
        _buf[_wpos++] = c;
        if (_wpos >= sizeof(_buf)) {
            _wpos = 0;
        }
    }
    uint8_t tx_sw;
    DigitalOut _nreset;
    DigitalOut _nisp;
};
